/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.zb;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.InflaterInputStream;

class CustomGZIPInputStream
extends InflaterInputStream {
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean closed = false;
    public static final int GZIP_MAGIC = 35615;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
    }

    public CustomGZIPInputStream(InputStream var1, int var2) throws IOException {
        super(var1);
        this.crc.reset();
    }

    public CustomGZIPInputStream(InputStream var1) throws IOException {
        this(var1, 512);
    }

    @Override
    public int read(byte[] var1, int var2, int var3) throws IOException {
        this.ensureOpen();
        if (this.eos) {
            return -1;
        }
        if ((var3 = super.read(var1, var2, var3)) == -1) {
            this.eos = true;
        } else {
            this.crc.update(var1, var2, var3);
        }
        return var3;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.eos = true;
            this.closed = true;
        }
    }
}

